﻿//-----------------------------------------------------------------------------
// <copyright file="TemperatureUtils.cs" company="eQ-3 Entwicklung GmbH">
//  Copyright (c) 2013 eQ-3 Entwicklung GmbH
// </copyright>
// <summary>
// Utility-class for converting different temperature units.
// </summary>
//-----------------------------------------------------------------------------
namespace Eq3.misc.USBI2C
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;

    /// <summary>
    /// Utility-class for converting different temperature units.
    /// </summary>
    public static class TemperatureUtils
    {
        /// <summary>
        /// Converts a temperature from Celsius to Fahrenheit.
        /// </summary>
        /// <param name="value">Temperature in Celsius.</param>
        /// <returns>Temperature in Fahrenheit.</returns>
        public static double ConvertCelsiusToFahrenheit(double value)
        {
            return (value * 1.8) + 32;
        }

        /// <summary>
        /// Converts a temperature from Celsius to Kelvin.
        /// </summary>
        /// <param name="value">Temperature in Celsius.</param>
        /// <returns>Temperature in Kelvin.</returns>
        public static double ConvertCelsiusToKelvin(double value)
        {
            return value + 273.15;
        }

        /// <summary>
        /// Converts a temperature from Fahrenheit to Celsius.
        /// </summary>
        /// <param name="value">Temperature in Fahrenheit.</param>
        /// <returns>Temperature in Celsius.</returns>
        public static double ConvertFahrenheitToCelsius(double value)
        {
            return (5.0 / 9.0) * (value - 32);
        }

        /// <summary>
        /// Converts a temperature from Kelvin to Celsius.
        /// </summary>
        /// <param name="value">Temperature in Kelvin.</param>
        /// <returns>Temperature in Celsius.</returns>
        public static double ConvertKelvinToCelsius(double value)
        {
            return value - 273.15;
        }
    }
}
