﻿//-----------------------------------------------------------------------------
// <copyright file="I2C4DLed.cs" company="eQ-3 Entwicklung GmbH">
//  Copyright (c) 2013 eQ-3 Entwicklung GmbH
// </copyright>
// <summary>
// Class-Representation of 4DLED (Wrapper for its two devices)
// </summary>
//-----------------------------------------------------------------------------
namespace Eq3.misc.USBI2C
{
    /// <summary>
    /// Class-Representation of 4DLED (Wrapper for its two devices).
    /// </summary>
    public class I2C4DLed
    {
        /// <summary>
        /// Initializes a new instance of the I2C4DLed class.
        /// </summary>
        /// <param name="usbI2C">I2C comport-device.</param>
        public I2C4DLed(UsbI2C usbI2C)
        {
            this.Saa1064 = new Saa1064(usbI2C);
            this.Mcp9801 = new MCP9801(usbI2C);
        }

        /// <summary>
        /// Gets or sets SAA1064-device.
        /// </summary>
        /// <value>I2C-4DLED Saa1064-device.</value>
        public Saa1064 Saa1064 { get; set; }

        /// <summary>
        /// Gets or sets MCP9801-device.
        /// </summary>
        /// <value>I2C-4DLED MCP9801-device.</value>
        public MCP9801 Mcp9801 { get; set; }
    }
}