//-----------------------------------------------------------------------------
// <copyright file="FormAbout.cs" company="eQ-3 Entwicklung GmbH">
//  Copyright (c) 2013 eQ-3 Entwicklung GmbH
// </copyright>
// <summary>
// About-dialog.
// </summary>
//-----------------------------------------------------------------------------
namespace Eq3.misc.USBI2C
{
    using System;
    using System.Windows.Forms;

    /// <summary>
    /// Info Dialog.
    /// </summary>
    public partial class FormAbout : Form
    {
        /// <summary>
        /// Initializes a new instance of the FormAbout class.
        /// </summary>
        public FormAbout()
        {
            this.InitializeComponent();
        }

        /// <summary>
        /// Initializes the texts for the info dialog.
        /// </summary>
        /// <param name="sender">Standard parameter sender.</param>
        /// <param name="e">Standard parameter e.</param>
        private void FormAbout_Load(object sender, EventArgs e)
        {
            this.Text = "Info ber ELV USB-I2C Testtool";
            this.btnOK.Text = "OK";
            this.picLogo.Image = Properties.Resources.ELVLogo;

            this.lbProductName.Text = "Testtool fr ELV USB-I2C-Interface\r\nund ELV IC Module";
            this.lbProductVersion.Text = string.Format("Version {0} ({1:d})", "1.3", new DateTime(2013, 7, 2));
        }

        /// <summary>
        /// Closes the window.
        /// </summary>
        /// <param name="sender">Standard parameter sender.</param>
        /// <param name="e">Standard parameter e.</param>
        private void BtnOK_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        /// <summary>
        /// Opens the url of the link cable.
        /// </summary>
        /// <param name="sender">Standard parameter sender.</param>
        /// <param name="e">Standard parameter e.</param>
        private void LabelURLSupport_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.ProcessStartInfo browser =
                new System.Diagnostics.ProcessStartInfo(this.lbURLSupport.Text);
            System.Diagnostics.Process.Start(browser);
        }
    }
}