﻿//-----------------------------------------------------------------------------
// <copyright file="ChartUtils.cs" company="eQ-3 Entwicklung GmbH">
//  Copyright (c) 2013 eQ-3 Entwicklung GmbH
// </copyright>
// <summary>
// Provides static methods for reordering the data of charts.
// </summary>
//-----------------------------------------------------------------------------
namespace Eq3.misc.USBI2C
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Windows.Forms.DataVisualization.Charting;

    /// <summary>
    /// Provides static methods for reordering the data of charts.
    /// </summary>
    public static class ChartUtils
    {
        /// <summary>
        /// Shifts all items of a SeriesCollection 1 index to the right.
        /// </summary>
        /// <param name="seriesCollection">SeriesCollection to shift.</param>
        public static void MoveSeriesPointsToRight(SeriesCollection seriesCollection)
        {
            DataPoint temp;
            foreach (Series series in seriesCollection)
            {
                for (int i = series.Points.Count - 1; i >= 0; i--)
                {
                    if (i - 1 < 0)
                    {
                        break;
                    }

                    temp = series.Points[i];
                    series.Points[i] = series.Points[i - 1];
                    series.Points[i - 1] = temp;
                }

                for (int i = 0; i < series.Points.Count; i++)
                {
                    series.Points[i].XValue = i + 1;
                }
            }
        }
    }
}
