﻿//-----------------------------------------------------------------------------
// <copyright file="BitOperationUtils.cs" company="eQ-3 Entwicklung GmbH">
//  Copyright (c) 2013 eQ-3 Entwicklung GmbH
// </copyright>
// <summary>
// Provides static properties for bit-operations.
// </summary>
//-----------------------------------------------------------------------------
namespace Eq3.misc.USBI2C
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;

    /// <summary>
    /// Static class which provides static properties for bit-operations.
    /// </summary>
    public static class BitOperationUtils
    {
        /// <summary>
        /// Gets the 1. Bit of a single Byte.
        /// </summary>
        /// <value>1. Bit of a single byte.</value>
        public static byte Bit0
        {
            get
            {
                return (byte)Math.Pow(2, 0);
            }
        }

        /// <summary>
        /// Gets the 2. Bit of a single Byte.
        /// </summary>
        /// <value>2. Bit of a single byte.</value>
        public static byte Bit1
        {
            get
            {
                return (byte)Math.Pow(2, 1);
            }
        }

        /// <summary>
        /// Gets the 3. Bit of a single Byte.
        /// </summary>
        /// <value>3. Bit of a single byte.</value>
        public static byte Bit2
        {
            get
            {
                return (byte)Math.Pow(2, 2);
            }
        }

        /// <summary>
        /// Gets the 4. Bit of a single Byte.
        /// </summary>
        /// <value>4. Bit of a single byte.</value>
        public static byte Bit3
        {
            get
            {
                return (byte)Math.Pow(2, 3);
            }
        }

        /// <summary>
        /// Gets the 5. Bit of a single Byte.
        /// </summary>
        /// <value>5. Bit of a single byte.</value>
        public static byte Bit4
        {
            get
            {
                return (byte)Math.Pow(2, 4);
            }
        }

        /// <summary>
        /// Gets the 6. Bit of a single Byte.
        /// </summary>
        /// <value>6. Bit of a single byte.</value>
        public static byte Bit5
        {
            get
            {
                return (byte)Math.Pow(2, 5);
            }
        }

        /// <summary>
        /// Gets the 7. Bit of a single Byte.
        /// </summary>
        /// <value>7. Bit of a single byte.</value>
        public static byte Bit6
        {
            get
            {
                return (byte)Math.Pow(2, 6);
            }
        }

        /// <summary>
        /// Gets the 8. Bit of a single Byte.
        /// </summary>
        /// <value>8. Bit of a single byte.</value>
        public static byte Bit7
        {
            get
            {
                return (byte)Math.Pow(2, 7);
            }
        }
    }
}