﻿//-----------------------------------------------------------------------------
// <copyright file="AbstractDevice.cs" company="eQ-3 Entwicklung GmbH">
//  Copyright (c) 2013 eQ-3 Entwicklung GmbH
// </copyright>
// <summary>
// Abstract class for inheriting basic traits of the device-classes
// </summary>
//-----------------------------------------------------------------------------
namespace Eq3.misc.USBI2C
{
    /// <summary>
    /// Abstract class for inheriting basic traits of the device-classes.
    /// </summary>
    public abstract class AbstractDevice
    {
        /// <summary>
        /// Initializes a new instance of the AbstractDevice class.
        /// </summary>
        /// <param name="usbI2C">I2C Comport-device.</param>
        public AbstractDevice(Eq3.misc.USBI2C.UsbI2C usbI2C)
        {
            this.UsbI2C = usbI2C;
        }

        /// <summary>
        /// Gets or sets wrapper for device communication with I2C.
        /// </summary>
        /// <value>Wrapper for device communication with I2C.</value>
        protected Eq3.misc.USBI2C.UsbI2C UsbI2C { get; set; }
    }
}