import json
import time
import serial
import paho.mqtt.client as mqtt
import random

#:_______USER CONFIGURATION________#

MQTT_BROKER = "XXX.XXX.XXX.XXX"

MQTT_PORT = 1883

MQTT_USER = "XXX"

MQTT_PASSWORD = "XXX"

UART_PORT = "/dev/ttyUSB0"

DEBUG = False

#___________END USER CONFIGURATION________#

DEVICE_ID = "USB-ESI3"

AVAILIABILITY_TOPIC = "home/energy/status"

POWER_IMPORT_TOPIC_BASE = "home/energy/power-import"
POWER_IMPORT_TOPIC_1 = "home/energy/power-import/1"
POWER_IMPORT_TOPIC_2 = "home/energy/power-import/2"
POWER_IMPORT_TOPIC_3 = "home/energy/power-import/3"

ENERGY_IMPORT_NT_BASE = "home/energy/total_import_nt"
ENERGY_IMPORT_NT_TOPIC_1 = "home/energy/total_import_nt/1"
ENERGY_IMPORT_NT_TOPIC_2 = "home/energy/total_import_nt/2"
ENERGY_IMPORT_NT_TOPIC_3 = "home/energy/total_import_nt/3"

ENERGY_IMPORT_TOPIC_BASE = "home/energy/total_import"
ENERGY_IMPORT_TOPIC_1 = "home/energy/total_import/1"
ENERGY_IMPORT_TOPIC_2 = "home/energy/total_import/2"
ENERGY_IMPORT_TOPIC_3 = "home/energy/total_import/3"

ENERGY_EXPORT_TOPIC_BASE = "home/energy/total_export"
ENERGY_EXPORT_TOPIC_1 = "home/energy/total_export/1"
ENERGY_EXPORT_TOPIC_2 = "home/energy/total_export/2"
ENERGY_EXPORT_TOPIC_3 = "home/energy/total_export/3"

GAS_USAGE_TOPIC_BASE = "home/energy/gas_import"
GAS_USAGE_TOPIC_1 = "home/energy/gas_import/1"
GAS_USAGE_TOPIC_2 = "home/energy/gas_import/2"
GAS_USAGE_TOPIC_3 = "home/energy/gas_import/3"

GAS_USAGE_MOMENTARY_TOPIC_BASE = "home/energy/gas_momentary"
GAS_USAGE_MOMENTARY_TOPIC_1 = "home/energy/gas_momentary/1"
GAS_USAGE_MOMENTARY_TOPIC_2 = "home/energy/gas_momentary/2"
GAS_USAGE_MOMENTARY_TOPIC_3 = "home/energy/gas_momentary/3"

UART_BAUD = 115200

client = mqtt.Client(mqtt.CallbackAPIVersion.VERSION1)
client.username_pw_set(MQTT_USER, MQTT_PASSWORD)
if( not DEBUG):
    def on_connect(cleint, userdata, flagsm, rc):
        print("MQTT verbunden, Code: ", rc )

        client.publish(AVAILIABILITY_TOPIC, "online", retain=True)

    client.on_connect = on_connect
    client.connect(MQTT_BROKER, MQTT_PORT, 60)

def publish_discovery():
    power_import_config_1 = {
        "name": "USB-ESI3-Power-Import",
        "state_topic": "POWER_IMPORT_TOPIC_1",
        "unit_of_measurement": "W",
        "device_class": "power",
        "state_class": "measurement",
        "unique_id": "usb-esi3_power_import_1",
        "availability_topic": AVAILIABILITY_TOPIC,
        "payload_available": "online",
        "payload_not_available": "offline",
        "device": {
            "identifiers": [DEVICE_ID],
            "name": "USB-ESI3",
            "manufacturer": "ELV Elektronik GmbH",
            "model": "UART-MQTT-Bridge"
        }
    }
    power_import_config_2 = {
        "name": "USB-ESI3-Power-Import",
        "state_topic": "POWER_IMPORT_TOPIC_2",
        "unit_of_measurement": "W",
        "device_class": "power",
        "state_class": "measurement",
        "unique_id": "usb-esi3_power_import_2",
        "availability_topic": AVAILIABILITY_TOPIC,
        "payload_available": "online",
        "payload_not_available": "offline",
        "device": {
            "identifiers": [DEVICE_ID],
            "name": "USB-ESI3",
            "manufacturer": "ELV Elektronik GmbH",
            "model": "UART-MQTT-Bridge"
        }
    }
    power_import_config_3 = {
        "name": "USB-ESI3-Power-Import",
        "state_topic": "POWER_IMPORT_TOPIC_3",
        "unit_of_measurement": "W",
        "device_class": "power",
        "state_class": "measurement",
        "unique_id": "usb-esi3_power_import_3",
        "availability_topic": AVAILIABILITY_TOPIC,
        "payload_available": "online",
        "payload_not_available": "offline",
        "device": {
            "identifiers": [DEVICE_ID],
            "name": "USB-ESI3",
            "manufacturer": "ELV Elektronik GmbH",
            "model": "UART-MQTT-Bridge"
        }
    }
    energy_import_config_1 = {
        "name": "USB-ESI3-Energy-Import_1",
        "state_topic": ENERGY_IMPORT_TOPIC_1,
        "unit_of_measurement": "kWh",
        "device_class": "energy",
        "state_class": "total_increasing",
        "unique_id": "usb-esi3_energy_import_1",
        "availability_topic": AVAILIABILITY_TOPIC,
        "payload_available": "online",
        "payload_not_available": "offline",
        "device": {
            "identifiers": [DEVICE_ID],
            "name": "USB-ESI3",
            "manufacturer": "ELV Elektronik GmbH",
            "model": "UART-MQTT-Bridge"
        }
    }
    energy_import_config_2 = {
        "name": "USB-ESI3-Energy-Import_2",
        "state_topic": ENERGY_IMPORT_TOPIC_2,
        "unit_of_measurement": "kWh",
        "device_class": "energy",
        "state_class": "total_increasing",
        "unique_id": "usb-esi3_energy_import_nt_2",
        "availability_topic": AVAILIABILITY_TOPIC,
        "payload_available": "online",
        "payload_not_available": "offline",
        "device": {
            "identifiers": [DEVICE_ID],
            "name": "USB-ESI3",
            "manufacturer": "ELV Elektronik GmbH",
            "model": "UART-MQTT-Bridge"
        }
    }
    energy_import_config_3 = {
        "name": "USB-ESI3-Energy-Import_3",
        "state_topic": ENERGY_IMPORT_TOPIC_3,
        "unit_of_measurement": "kWh",
        "device_class": "energy",
        "state_class": "total_increasing",
        "unique_id": "usb-esi3_energy_import_3",
        "availability_topic": AVAILIABILITY_TOPIC,
        "payload_available": "online",
        "payload_not_available": "offline",
        "device": {
            "identifiers": [DEVICE_ID],
            "name": "USB-ESI3",
            "manufacturer": "ELV Elektronik GmbH",
            "model": "UART-MQTT-Bridge"
        }
    }
    energy_import_nt_config_1 = {
        "name": "USB-ESI3-Energy-Import_NT_1",
        "state_topic": ENERGY_IMPORT_NT_TOPIC_1,
        "unit_of_measurement": "kWh",
        "device_class": "energy",
        "state_class": "total_increasing",
        "unique_id": "usb-esi3_energy_import_nt_1",
        "availability_topic": AVAILIABILITY_TOPIC,
        "payload_available": "online",
        "payload_not_available": "offline",
        "device": {
            "identifiers": [DEVICE_ID],
            "name": "USB-ESI3",
            "manufacturer": "ELV Elektronik GmbH",
            "model": "UART-MQTT-Bridge"
        }
    }
    energy_import_nt_config_2 = {
        "name": "USB-ESI3-Energy-Import_NT_2",
        "state_topic": ENERGY_IMPORT_NT_TOPIC_2,
        "unit_of_measurement": "kWh",
        "device_class": "energy",
        "state_class": "total_increasing",
        "unique_id": "usb-esi3_energy_import_nt_2",
        "availability_topic": AVAILIABILITY_TOPIC,
        "payload_available": "online",
        "payload_not_available": "offline",
        "device": {
            "identifiers": [DEVICE_ID],
            "name": "USB-ESI3",
            "manufacturer": "ELV Elektronik GmbH",
            "model": "UART-MQTT-Bridge"
        }
    }
    energy_import_nt_config_3 = {
        "name": "USB-ESI3-Energy-Import_NT_3",
        "state_topic": ENERGY_IMPORT_NT_TOPIC_3,
        "unit_of_measurement": "kWh",
        "device_class": "energy",
        "state_class": "total_increasing",
        "unique_id": "usb-esi3_energy_export_nt_3",
        "availability_topic": AVAILIABILITY_TOPIC,
        "payload_available": "online",
        "payload_not_available": "offline",
        "device": {
            "identifiers": [DEVICE_ID],
            "name": "USB-ESI3",
            "manufacturer": "ELV Elektronik GmbH",
            "model": "UART-MQTT-Bridge"
        }
    }
    energy_export_config_1 = {
        "name": "USB-ESI3-Energy-Export_1",
        "state_topic": ENERGY_EXPORT_TOPIC_1,
        "unit_of_measurement": "kWh",
        "device_class": "energy",
        "state_class": "total_increasing",
        "unique_id": "usb-esi3_energy_export_1",
        "availability_topic": AVAILIABILITY_TOPIC,
        "payload_available": "online",
        "payload_not_available": "offline",
        "device": {
            "identifiers": [DEVICE_ID],
            "name": "USB-ESI3",
            "manufacturer": "ELV Elektronik GmbH",
            "model": "UART-MQTT-Bridge"
        }
    }
    energy_export_config_2 = {
        "name": "USB-ESI3-Energy-Export_2",
        "state_topic": ENERGY_EXPORT_TOPIC_2,
        "unit_of_measurement": "kWh",
        "device_class": "energy",
        "state_class": "total_increasing",
        "unique_id": "usb-esi3_energy_export_2",
        "availability_topic": AVAILIABILITY_TOPIC,
        "payload_available": "online",
        "payload_not_available": "offline",
        "device": {
            "identifiers": [DEVICE_ID],
            "name": "USB-ESI3",
            "manufacturer": "ELV Elektronik GmbH",
            "model": "UART-MQTT-Bridge"
        }
    }
    energy_export_config_3 = {
        "name": "USB-ESI3-Energy-Export_3",
        "state_topic": ENERGY_EXPORT_TOPIC_3,
        "unit_of_measurement": "kWh",
        "device_class": "energy",
        "state_class": "total_increasing",
        "unique_id": "usb-esi3_energy_export_3",
        "availability_topic": AVAILIABILITY_TOPIC,
        "payload_available": "online",
        "payload_not_available": "offline",
        "device": {
            "identifiers": [DEVICE_ID],
            "name": "USB-ESI3",
            "manufacturer": "ELV Elektronik GmbH",
            "model": "UART-MQTT-Bridge"
        }
    }
    gas_usage_config_1 = {
        "name": "USB-ESI3-Gas-Import_1",
        "state_topic": GAS_USAGE_TOPIC_1,
        "unit_of_measurement": "m3",
        "device_class": "power",
        "state_class": "measurement",
        "unique_id": "usb-esi3_gas_usage_1",
        "availability_topic": AVAILIABILITY_TOPIC,
        "payload_available": "online",
        "payload_not_available": "offline",
        "device": {
            "identifiers": [DEVICE_ID],
            "name": "USB-ESI3",
            "manufacturer": "ELV Elektronik GmbH",
            "model": "UART-MQTT-Bridge"
        }
    }
    gas_usage_config_2 = {
        "name": "USB-ESI3-Gas-Import_2",
        "state_topic": GAS_USAGE_TOPIC_2,
        "unit_of_measurement": "m3",
        "device_class": "power",
        "state_class": "measurement",
        "unique_id": "usb-esi3_gas_import_2",
        "availability_topic": AVAILIABILITY_TOPIC,
        "payload_available": "online",
        "payload_not_available": "offline",
        "device": {
            "identifiers": [DEVICE_ID],
            "name": "USB-ESI3",
            "manufacturer": "ELV Elektronik GmbH",
            "model": "UART-MQTT-Bridge"
        }
    }
    gas_usage_config_3 = {
        "name": "USB-ESI3-Gas-Import_3",
        "state_topic": GAS_USAGE_TOPIC_3,
        "unit_of_measurement": "m3",
        "device_class": "power",
        "state_class": "measurement",
        "unique_id": "usb-esi3_gas_usage_3",
        "availability_topic": AVAILIABILITY_TOPIC,
        "payload_available": "online",
        "payload_not_available": "offline",
        "device": {
            "identifiers": [DEVICE_ID],
            "name": "USB-ESI3",
            "manufacturer": "ELV Elektronik GmbH",
            "model": "UART-MQTT-Bridge"
        }
    }
    gas_momentary_config_1 = {
        "name": "USB-ESI3-Power-Import",
        "state_topic": GAS_USAGE_MOMENTARY_TOPIC_1,
        "unit_of_measurement": "m3",
        "device_class": "power",
        "state_class": "measurement",
        "unique_id": "usb-esi3_gas_momentary_1",
        "availability_topic": AVAILIABILITY_TOPIC,
        "payload_available": "online",
        "payload_not_available": "offline",
        "device": {
            "identifiers": [DEVICE_ID],
            "name": "USB-ESI3",
            "manufacturer": "ELV Elektronik GmbH",
            "model": "UART-MQTT-Bridge"
        }
    }
    gas_momentary_config_2 = {
        "name": "USB-ESI3-Power-Import",
        "state_topic": GAS_USAGE_MOMENTARY_TOPIC_2,
        "unit_of_measurement": "m3",
        "device_class": "power",
        "state_class": "measurement",
        "unique_id": "usb-esi3_gas_momentary_2",
        "availability_topic": AVAILIABILITY_TOPIC,
        "payload_available": "online",
        "payload_not_available": "offline",
        "device": {
            "identifiers": [DEVICE_ID],
            "name": "USB-ESI3",
            "manufacturer": "ELV Elektronik GmbH",
            "model": "UART-MQTT-Bridge"
        }
    }
    gas_momentary_config_3 = {
        "name": "USB-ESI3-Power-Import",
        "state_topic": GAS_USAGE_MOMENTARY_TOPIC_3,
        "unit_of_measurement": "m3",
        "device_class": "power",
        "state_class": "measurement",
        "unique_id": "usb-esi3_gas_momentary_3",
        "availability_topic": AVAILIABILITY_TOPIC,
        "payload_available": "online",
        "payload_not_available": "offline",
        "device": {
            "identifiers": [DEVICE_ID],
            "name": "USB-ESI3",
            "manufacturer": "ELV Elektronik GmbH",
            "model": "UART-MQTT-Bridge"
        }
    }

    for i in range(1,3):
        client.publish(f"homeassistant/sensor/{DEVICE_ID}/1/power/config", json.dumps(power_import_config_1), retain=True)
        client.publish(f"homeassistant/sensor/{DEVICE_ID}/2/power/config", json.dumps(power_import_config_2), retain=True)
        client.publish(f"homeassistant/sensor/{DEVICE_ID}/3/power/config", json.dumps(power_import_config_3), retain=True)

        client.publish(f"homeassistant/sensor/{DEVICE_ID}/1/energy_import_nt/config", json.dumps(energy_import_nt_config_1), retain=True)
        client.publish(f"homeassistant/sensor/{DEVICE_ID}/2/energy_import_nt/config", json.dumps(energy_import_nt_config_2), retain=True)
        client.publish(f"homeassistant/sensor/{DEVICE_ID}/3/energy_import_nt/config", json.dumps(energy_import_nt_config_3), retain=True)

        client.publish(f"homeassistant/sensor/{DEVICE_ID}/1/energy_import/config", json.dumps(energy_import_config_1), retain=True)
        client.publish(f"homeassistant/sensor/{DEVICE_ID}/2/energy_import/config", json.dumps(energy_import_config_2), retain=True)
        client.publish(f"homeassistant/sensor/{DEVICE_ID}/3/energy_import/config", json.dumps(energy_import_config_3), retain=True)

        client.publish(f"homeassistant/sensor/{DEVICE_ID}/1/energy_export/config", json.dumps(energy_export_config_1), retain=True)
        client.publish(f"homeassistant/sensor/{DEVICE_ID}/2/energy_export/config", json.dumps(energy_export_config_2), retain=True)
        client.publish(f"homeassistant/sensor/{DEVICE_ID}/3/energy_export/config", json.dumps(energy_export_config_3), retain=True)

        client.publish(f"homeassistant/sensor/{DEVICE_ID}/1/gas_usage/config", json.dumps(gas_usage_config_1), retain=True)
        client.publish(f"homeassistant/sensor/{DEVICE_ID}/2/gas_usage/config", json.dumps(gas_usage_config_2), retain=True)
        client.publish(f"homeassistant/sensor/{DEVICE_ID}/3/gas_usage/config", json.dumps(gas_usage_config_3), retain=True)

        client.publish(f"homeassistant/sensor/{DEVICE_ID}/1/gas_momentary/config", json.dumps(gas_momentary_config_1), retain=True)
        client.publish(f"homeassistant/sensor/{DEVICE_ID}/2/gas_momentary/config", json.dumps(gas_momentary_config_2), retain=True)
        client.publish(f"homeassistant/sensor/{DEVICE_ID}/3/gas_momentary/config", json.dumps(gas_momentary_config_3), retain=True)

publish_discovery()

if not DEBUG:
    ser = serial.Serial(UART_PORT, UART_BAUD, timeout=1)
else:
    energy_import = 12000.0
    energy_export = 400.0
    power_import = 0
    power_export = 0

try:
    while True:
        if not DEBUG:
            line = ser.readline().decode().strip()
        else:
            power_import = random.randrange(100,200)
            power_export = random.randrange(100,200)
            line = f"power_import:{power_import};power_export:{power_export};energy_import:{energy_import};energy_export:{energy_export}"
            energy_import+=random.random()/100.0
            energy_export+=random.random()/100.0
        if not line:
            continue
        try:
            parts = line.split(";")
            data = {}
            for p in parts:
                key, value = p.split(":")
                data[key] = int(value)
            client.publish(AVAILIABILITY_TOPIC, "online")
            if "Connector" in data:
                if "power" in data:
                    client.publish(f"{POWER_IMPORT_TOPIC_BASE}/{str(data["Connector"])}", data["power"])
                if "energy_import_nt" in data:
                    client.publish(f"{ENERGY_IMPORT_NT_BASE}/{str(data["Connector"])}", data["energy_import_nt"])
                if "energy_import" in data:
                    client.publish(f"{ENERGY_IMPORT_TOPIC_BASE}/{str(data["Connector"])}", data["energy_import"])
                if "energy_export" in data:
                    client.publish(f"{ENERGY_EXPORT_TOPIC_BASE}/{str(data["Connector"])}", data["energy_export"])
                if "volume_import" in data:
                    client.publish(f"{GAS_USAGE_TOPIC_BASE}/{str(data["Connector"])}", data["volume_import"])
                if "momentary_use" in data:
                    client.publish(f"{GAS_USAGE_TOPIC_BASE}/{str(data["Connector"])}", data["energy_export"])
            print("gesendet: ", data)
        except Exception as e:
            print("Fehler beim Parsen: ", e)

        time.sleep(1)
except KeyboardInterrupt:
    print("Beende....")
    client.publish(AVAILIABILITY_TOPIC, "offline", retain=True)
    if DEBUG:
        ser.close()
    client.disconnect()
