/**
* @file scale.h
* @brief Header file for scale functions.
* @author Marcel Maas, eQ-3 Entwicklung GmbH
**/
/*-----------------------------------------------------------------------------
* Copyright 2012 eQ-3 Entwicklung GmbH
* All Rights Reserved.
*
* The information contained in this file is confidential property of "eQ-3
* Entwicklung GmbH". The use copying, transfer or disclosure is prohibited
* except by written agreement with "eQ-3 Entwicklung GmbH".
*----------------------------------------------------------------------------*/
/*
* $URL:$
* $Author:      Marcel Maas$
* $Date:        08.05.2025$
* $Revision:    1$
*/
/*----------------------------------------------------------------------------*/

// Define to prevent recursive inclusion ---------------------------------------
#ifndef __SCALE_H
#define __SCALE_H

#ifdef __cplusplus
 extern "C" {
#endif

// Includes --------------------------------------------------------------------
#include <stdbool.h>
#include <stdint.h>

// Definitions -----------------------------------------------------------------
#define SCALE_MAX11210                      1
#define SCALE_ADC                           SCALE_MAX11210

#define SCALE_SAMPLES                       100
#define SCALE_TRIM_COUNT                    10

// Exported types --------------------------------------------------------------
typedef enum
{
  SCALE_READ_AVGM_DEFAULT = 0x00,

  SCALE_READ_AVGM_TRIM_MEAN,
  SCALE_READ_AVGM_TRIM_MODE,
} scale_read_avg_mode_t;

// Exported macro --------------------------------------------------------------

// Exported functions ----------------------------------------------------------
bool scale_init( void );

void scale_set_scale( double d_scale );
double scale_get_scale( void );
void scale_tare( void );
void scale_calibrate( uint32_t u32_weight_in_grams );
int64_t scale_read_average( scale_read_avg_mode_t mode );
int64_t scale_read_average_trim_mean( int32_t *s32_adc_data );
int64_t scale_read_average_trim_mode( int32_t *s32_adc_data );
void scale_set_offset( int64_t s64_offset );
int64_t scale_get_offset( void );
double scale_get_units( uint8_t u8_times );
double scale_get_value( uint8_t u8_times );

void s32_qsort_range( int32_t *s32_data, int32_t s32_lo, int32_t s32_hi );
void s32_qsort( int32_t *s32_data, uint32_t u32_count );

#ifdef __cplusplus
}
#endif

/**
  * @}
  */

#endif /* __SCALE_H */

