#include "ELV-BM-MCU.h"
#include <LiquidCrystal_I2C.h>

#include "scale.h"
#include "MAX11210.h"
#include "Wire.h"
#include "MyWire.h"

#include <LiquidCrystal_I2C.h>       // including Display adress
LiquidCrystal_I2C lcd(0x27, 20, 4);  // Display adress, column and row size


#define SCALE_CALIB 1
#define SCALE_APP 2
#define ADC_DIFF 3
#define ADC_UNI 4

#define APP_USE ADC_UNI

void setup() {
  Serial1.begin(115200);

  lcd.init();           // Init Dispaly
  lcd.backlight();      // activate Backlight
  lcd.setCursor(1, 1);  // column, row

  if (APP_USE == SCALE_CALIB) {
    lcd.print("Kalibrierungsmodus");
  } else if (APP_USE == SCALE_APP) {
    lcd.setCursor(7, 1);
    lcd.print("Waage");
  } else if (APP_USE == ADC_DIFF) {
    lcd.setCursor(0, 1);
    lcd.print("Bipolare Messung");
  } else if (APP_USE == ADC_UNI) {
    lcd.setCursor(0, 1);
    lcd.print("Unipolare Messung");
  }

  MyWireObj.init(
    []() {
      Wire.begin();
    },  // begin
    [](uint8_t addr) {
      Wire.beginTransmission(addr);
    },  // beginTransmission
    [](uint8_t data) {
      return Wire.write(data);
    },  // write
    []() {
      return Wire.endTransmission();
    },  // endTransmission
    [](uint8_t addr, uint8_t qty) {
      return Wire.requestFrom(addr, qty);
    },  // requestFrom
    []() {
      return Wire.read();
    },  // read
    [](uint32_t c) {
      Wire.setClock(c);
    },  // setClock
    []() {
      return Wire.available();
    }  // available
  );

  delay(1000);
#if defined(APP_USE) && (APP_USE == SCALE_CALIB)
  Serial1.println(scale_init());
  delay(100);
  scale_tare();
  delay(100);
#elif defined(APP_USE) && (APP_USE == SCALE_APP)
  Serial1.println(scale_init());
  delay(100);
  scale_set_offset(5508);
  scale_set_scale(-326.21f);
#elif defined(APP_USE) && (APP_USE == ADC_DIFF)
  max11210_init();
  Serial1.println(max11210_copro_device_id(COPRO_ADDR));
  max11210_copro_set_input_range(MAX11210_BIPOLAR, COPRO_ADDR);
  delay(100);
  max11210_copro_set_format(MAX11210_2SCOMPL, COPRO_ADDR);  // value = { MAX11210_OFFSET, MAX11210_2SCOMPL }
  delay(100);
#else
  max11210_init();
  Serial1.println(max11210_copro_device_id(COPRO_ADDR));
#endif
  delay(1000);
  lcd.clear();
}

void loop() {
  // Displaying Module
  if (APP_USE == SCALE_CALIB) {
    //nothing
  } else if (APP_USE == SCALE_APP) {
    lcd.setCursor(7, 0);
    lcd.print("Waage");
    lcd.setCursor(3, 1);
    lcd.print("Gewicht in Kg: ");
    lcd.setCursor(3, 2);
  } else if (APP_USE == ADC_DIFF) {
    lcd.setCursor(0, 1);
    lcd.print("Bipolare Messung");
  } else if (APP_USE == ADC_UNI) {
    lcd.setCursor(0, 1);
    lcd.print("Unipolare Messung");
  }

  Serial1.println("########################################");

#if defined(APP_USE) && (APP_USE == SCALE_CALIB)
  scale_calibrate(1778);
  Serial1.println(scale_get_scale());
  Serial1.println(scale_get_offset());
#elif defined(APP_USE) && (APP_USE == SCALE_APP)
 
  float kg = scale_get_units(30);
  lcd.clear();
  lcd.setCursor(7, 0);
  lcd.print("Waage");
  lcd.setCursor(3, 1);
  lcd.print("Gewicht in Kg: ");
  lcd.setCursor(3, 2);
  lcd.print(kg, 3);
   Serial1.println( kg );
#elif defined(APP_USE) && ((APP_USE == ADC_DIFF) || (APP_USE == ADC_UNI))
  max11210_copro_meas_uv(COPRO_ADDR);
  delay(100);
  double uV = max11210_copro_get_uv(COPRO_ADDR);
  max11210_copro_get_uv(COPRO_ADDR);
  lcd.clear();
  lcd.setCursor(7, 0);
  
  lcd.setCursor(1, 1);
  lcd.print("U in Mikrovolt: ");
  lcd.setCursor(3, 2);
  lcd.print(uV, 3);
  Serial1.println(uV);
  delay(10);
#else
  // ...
#endif

  Serial1.println("########################################");
  Serial1.println("");
  delay(1000);
}